<?php
/*==============================
title: "hnmTournament Criant"
author: "Keiichi Nagasawa" http://hanamachi.com
source: "hnmTournament Criant" https://hnm.li/32
license: CC BY 4.0 https://creativecommons.org/licenses/by/4.0/
==============================*/
global $_conf;
global $_tnmt; $_tnmt = new HNM_TNMNT();
$_tnmt ->_hnm_conf();

$_conf['posturl'] = 'http://ponbei.com/kaisei/'; //本番運用
$_conf['lang'] = 'japanese'; //言語
//$_conf['lang'] = 'english';
$_conf['charset'] = 'utf8'; //キャラセット utf8

if($_conf['lang'] == 'japanese'){
	$_conf['addnew'] = '新しいトーナメント表を作成してください。'; //新規トーナメント表作成（日本語）
}else{
	$_conf['addnew'] = 'Please add new tournament.'; //新規トーナメント表作成（英語）
}
$_conf['page'] = 'api'; //呼出し方 api, js 

$_tnmt -> _hnm_post();
if($_conf['sts']=='list'){ $_content = _hnm_index(); }
else{ $_content = $_tnmt -> _hnm_curl(); }
echo _hnm_set_page($_content);

function _hnm_pwd(){ //デフォルト：各パスを設定
	global $_conf;
	$_listfn = 'index'; //リストJSON ファイル名
	$_url = 'http://'.$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI'];
	$url = parse_url($_url);
	$_conf['requrl'] = $_conf['homeurl'] = $url['scheme'].'://'.$url['host'].$url['path'];
	$_pwd = explode('/', $_conf['homeurl']);
	array_pop($_pwd);
	$_conf['localpath'] = implode('/', $_pwd).'/';
	$_conf['logpath'] = getcwd().'/'.'jsons';
	$_conf['indexfn'] = $_conf['logpath'].'/'.$_listfn.'.json';
	if(isset($_conf['fnm']) && $_conf['fnm']){
		$_conf['requrl'] = _hnm_url_set($_conf['requrl'], $_conf['fnm']);
		$_conf['jsonfn'] = $_conf['logpath'].'/'.$_conf['fnm'].'.json';
	}
}
function _hnm_own(){ //デフォルト：管理者権限の確認
	global $_conf;
	$_conf['own'] = 1;
}
function _hnm_url_set($_url, $_fnm){ // デフォルト：jsonファイルを読むURLを準備する
	global $_tnmt;
	$_para = array('fnm'=>$_fnm);
	return $_tnmt -> _hnm_url_ready($_url, $_para);
}
function _hnm_get_json(){ //デフォルト：json読込
	global $_conf, $_tnmt;
	if(!$_conf['json'] && $_conf['jsonfn'] && file_exists($_conf['jsonfn'])){
		$_conf['json'] = _hnm_json($_conf['jsonfn']);
	}
}
function _hnm_index(){ //デフォルト：リスト表示
	global $_conf, $_tnmt;
	if(file_exists($_conf['indexfn'])){
		$_index = _hnm_json($_conf['indexfn']);
		$_index = json_decode($_index, TRUE);
		$_index = array_reverse($_index, TRUE);
		$r[] = '<ul>';
		foreach ($_index as $key => $value) {
			$r[] = '<li><a href="'.$_conf['requrl'].'?fnm='.$key.'">'.$value.'</a></li>';
		}
		$r[] = '</ul>';
	}
	$r[] = '<p><a href="'.$_conf['requrl'].'?sts=add">';
	$r[] = $_conf['addnew'];
	$r[] = '</a></p>';
	return implode("\n", $r);
}
function _hnm_json($_fn, $_mode='r', $_value=''){ //デフォルト：ファイル読込
	$r = NULL;
	$_handle = fopen($_fn, $_mode);
	switch($_mode){
		case 'w': fwrite($_handle, $_value);
			break;
		case 'r': $r = fread($_handle, filesize($_fn));
			break;
	}
	fclose($_handle);
	return $r;
}
function _hnm_set_page($content, $stylesheet=NULL){ //暫定：ページで表示させる。
	$r=array();
	$r[]="<html lang='ja'>";
	$r[]="<head>";
	$r[]="<meta charset='utf-8'>";
	$r[]="<title>はなまるトーナメントメーカー（仮）</title>";
	$r[]="<meta name='viewport' content='width=device-width, initial-scale=1'>";
	if($stylesheet){ $r[]="<link rel='stylesheet' type='text/css' href='".$stylesheet."'>"; }
	$r[]="</head>";
	$r[]="<body>";
	$r[]=$content;
	$r[]="</body>";
	$r[]="</html>";
	return implode("\n", $r);
}

class HNM_TNMNT{
	function _hnm_conf(){ //conf 設定
		global $_conf, $_tnmt;
		$_para = array( //POSTで受診するパラメータキー
			'sts','mod','act','num','page','lang','charset','title','own','time','fnm',
			'posturl','localpath','homeurl','requrl','logpath','indexfn','jsonfn','editdata','json'
		);
		$this -> _hnm_keyset($_para); //ポストデータをセット
		_hnm_pwd(); //各パスを設定
		_hnm_own(); //管理者権限の確認
		_hnm_get_json(); //JSON設定
		$_conf['time'] = time(); //タイムスタンプを取得
	}
	function _hnm_post(){ //実装：送信データ作成
		global $_conf;
		$_para = [];
		switch ($_conf['sts']) {
			case 'show':
				if($_conf['mod']=='game'){
					$_para = array('home', 'away');
					$this -> _hnm_keyset($_para);
				}
				break;

			case 'edit': //games の編集画面
				if(isset($_conf['mod']) && $_conf['mod']){ // 編集フォーム
					switch ($_conf['mod']) {
						case 'conf': $_para = array( "title", "gdsc", "glink", "plink", "cwid", "pwid" ); break;
						case 'player': $_para = array( "name", "purl", "pwin", "note" ); break;
						case 'game': $_para = array( "gwin", "desc", "gurl", "note", "home", "away" ); break;
					}
					$this -> _hnm_keyset($_para);
				}
				if(isset($_conf['act']) && $_conf['act']=='end'){ // jsonを保存します
					$this -> _hnm_json_edit();
				} 
				break;

			case 'add':
				$_para = array('nxt', 'bak', 'title', 'kisn');
				$this -> _hnm_keyset($_para);

				$_para = [];
				$this -> _hnm_keyset($_para, 'player_'); //プレイヤー名の受け渡し

				if($_conf['act']=='end'){ //jsonを保存します
					$this -> _hnm_json_add();
				}
				break;

			default: //リスト表示させます。
				$_conf['sts'] = 'list';
				break;
		}
		if($_conf['sts']=='list' && $_conf['json']){
			$_conf['sts'] = 'show';
		}
	}

	function _hnm_url_ready($_url, $_para){ //URL にパラメータを追加する
		$r = NULL;
		$_tie = '&';
		$para = [];
		foreach ($_para as $key => $val) { $para[] = $key.'='.$val; }
		$r = implode($_tie, $para);
		if(!strpos($_url, '?')){ $_tie = '?'; }
		return $_url.$_tie.$r;
	}

	function _hnm_keyset($_para=[], $_prefix=NULL){ //ポストデータを[$_conf]にセット
		global $_conf;
		$_len = NULL;
		$_req = $_REQUEST;
		if($_prefix){
			$_para = [];
			$_len = strlen($_prefix);
			$_req_keys = array_keys($_req);
			foreach ($_req_keys as $_key) {
				if(substr($_key, 0, $_len) == $_prefix){
					$_para[] = $_key;
				}
			}
		}
		foreach ($_para as $_key) {
			$_conf[$_key] = '';
			if(isset($_req[$_key]) && $_req[$_key]){
				// 入力データをチェックするファンクションを入れる
				$_conf[$_key] = $_req[$_key];
			}
		}
	}

	function _hnm_curl(){ //実装：curlファンクション
		global $_conf;
		$r = NULL;
		$crl = curl_init($_conf['posturl']);
		$options = array(
			CURLOPT_HEADER => FALSE,
			CURLOPT_SSL_VERIFYPEER => FALSE,
			CURLOPT_RETURNTRANSFER => TRUE,
			CURLOPT_POSTFIELDS => http_build_query($_conf),
			CURLOPT_CONNECTTIMEOUT => 5
		);
		curl_setopt_array($crl, $options);
		$r = curl_exec($crl);
		if(!$r){ $r = curl_error($crl); }
		curl_close($crl);
		return $r;
	}

	function _hnm_json_index(){ //リスト作成
		global $_conf;
		$_fn = $_conf['indexfn'];

		if(file_exists($_fn)){
			$_indexes = _hnm_json($_fn); // インディクス読み込み
			$_indexes = json_decode($_indexes, TRUE);
			$_keys = array_keys($_indexes);
			$_json = array();
			foreach ($_keys as $key) {
				if($key != $_conf["fnm"]){
					$_json[$key] = $_indexes[$key];
				}
			}
		}

		$_json[$_conf["fnm"]] = $_conf["title"];
		$json = json_encode($_json, JSON_UNESCAPED_UNICODE);
		_hnm_json($_fn, 'w', $json); // インディクス書き込み
	}

	function _hnm_json_add(){ //json保存
		global $_conf;
		$_conf["requrl"] = $_conf["requrl"].'?fnm='.$_conf['time'];
		$_conf['fnm'] = $_conf['time'];
		$_fn = $_conf['logpath'].'/'.$_conf['fnm'].'.json';

		_hnm_json($_fn, 'w', $_conf['json']); // 大会データ書き込み
		$this->_hnm_json_index();
	}

	function _hnm_json_edit(){ //json更新
		global $_conf;
		if( !isset( $_conf["title"] ) || $_conf["title"] ){
			$_tmp = json_decode( $_conf['json'] ,true );
			$_conf["title"] = $_tmp['conf']['title'];
		}
		$_fn = $_conf['logpath'].'/'.$_conf['fnm'].'.json';
		_hnm_json($_fn, 'w', $_conf['json']); // 大会データ書き込み
		$this->_hnm_json_index();
	}
}
?>