<?php
/*
新しいモジュールを作成する時にデフォルトのモジュールをコピーするスクリプトです。
php5.0以上が動作する環境でご使用ください。

１）元になるモジュールがあるディリクトリを「ベースディリクトリ」として指定します。
２）元になるモジュールの名前、ファイル内で使われているキーを設定します。
３）新しくつくるモジュールの名前とキーを指定します。

４）このスクリプトを動作させます。上手く動けば新しいディリクトリが作成されています。

５）各言語は変更しませんので、
　language 内の各言語ディリクトリの“main.ini“、”modinfo.ini”の内容を直接編集してください。

６）Netcommonsのモジュールディリクトリに移動させて、管理画面から読み込めば、
　コピーしたモジュールを操作させる事ができます。

　このファイルのライセンスはNetcommons 2.4.2.1のライセンスに準じます。
　
　2015.5.15　有限会社はなまちや　長澤啓一		
*/

//設定項目
	$modname['bs'] = '/[ベースディリクトリ]/webapp/modules/'; //ベースディリクトリ
	$modname['nm'] = 'multidatabase'; //元になるモジュールの名前
	$modname['nn'] = '[newname]'; //新しいモジュールの名前
	$modname['mk'] = 'mdb'; //元になるモジュールのキー
	$modname['nk'] = '[newkey]'; //新しいモジュールのキー

//以下スクリプト
	$list[0] = list_files( $modname['bs'], $modname['nm'] );
	$list[1] = list_files_new($list[0], $modname);

	copy_dir($modname, $list);

	function file_copy($bfn, $nfn, $b, $n){
		if( preg_match('/text/i', mime_content_type($bfn))){
			$txt = file_get_contents($bfn);
			$txt = str_replace($b, $n, $txt);
			return file_put_contents($nfn, $txt);
		}else{
			return copy($bfn, $nfn);
		}
	}

	function copy_dir($m, $l){
		$dir = $m['bs'];
		$b = txt_edit($m['nm'], $m['mk']);
		$n = txt_edit($m['nn'], $m['nk']);

		foreach ( $l[1] as $k => $fn ){
			$dir = explode('/', $fn);
			unset($dir[count($dir)-1]);
			$dir = implode('/', $dir);

			if(!is_dir($dir)){ mkdir($dir, 0755, true); }

			$r = file_copy($l[0][$k], $fn, $b, $n);
			if($r){echo $fn."<br />\n";}
		}
	}

	function list_files($b, $m){
		$dir = $b.$m.'/';
		$list = array();
		$files = scandir($dir);
		foreach($files as $file){
			if($file == '.' || $file == '..' || $file == '.DS_Store'){
				continue;
			} else if (is_file($dir . $file)){
				$list[] = $dir . $file;
			} else if( is_dir($dir . $file) ) {
				$list = array_merge($list, list_files($dir , $file));
			}
		}
		return $list;
	}

	function list_files_new($list, $m){
		$b = txt_edit($m['nm']);
		$n = txt_edit($m['nn']);
		foreach ($list as $k => $fn) {
			$list2[$k] = str_replace($b, $n, $fn);
		}
		return $list2;
	}

	function txt_edit($mod, $key=''){
		$r[0] = $mod;
		$r[1] = ucfirst(strtolower($mod));
		$r[2] = strtoupper($mod);
		if($key){
			$r[3] = $key;
			$r[4] = ucfirst(strtolower($key));
			$r[5] = strtoupper($key);
		}
		return $r;
	}

?>